#include "LloydMedian.hpp"
#include "KumarMedian.hpp"

LloydMedian::LloydMedian(std::function<Metric<Point>*()> createMetric, std::function<Norm<Point>*() > createNorm) :
        sampling(createMetric),
        weiszfeld(createMetric),
        centerOfGravity(createMetric),
        kumar(createMetric, createNorm),
        metric(createMetric()),
        weiszfeldMaxIt(2),
        kumarMedianIterations(5)
{
}

LloydMedian::~LloydMedian()
{
}

